XIncludeFile "brushes.pbi"

Procedure New_brush()
  If OpenWindow(#Window_new_brush, 0, 0, #Window_new_brush_w, #Window_new_brush_h, "New brush", #PB_Window_WindowCentered | #PB_Window_TitleBar, WindowID(#Window))
    TextGadget(#TileText, #TileText_x, #TileText_y, #TileText_w, #TileText_h, "Tile : ")
    ComboBoxGadget(#ComboBox, #ComboBox_x, #ComboBox_y, #ComboBox_w, #ComboBox_h, #PB_ComboBox_Image)
    If DatabaseQuery(#Database, "SELECT * FROM tile ORDER BY id;")
      While NextDatabaseRow(#Database)
        AddGadgetItem(#ComboBox, -1, GetDatabaseString(#Database, 1), ImageID(LoadImage(#PB_Any, "tiles\"+GetDatabaseString(#Database, 1))))
      Wend
      FinishDatabaseQuery(#Database)
    Else
      MessageRequester("DatabaseUpdate() error", DatabaseError())
      End
    EndIf
    CheckBoxGadget(#AnimCheckBox, #AnimCheckBox_x, #AnimCheckBox_y, #AnimCheckBox_w, #AnimCheckBox_h, "Animated")
    TextGadget(#OffsetText, #OffsetText_x, #OffsetText_y, #OffsetText_w, #OffsetText_h, ", offset #")
    SpinGadget(#OffsetSpin, #OffsetSpin_x, #OffsetSpin_y, #OffsetSpin_w, #OffsetSpin_h, 0, 255, #PB_Spin_Numeric)
    SetGadgetState(#OffsetSpin, 0)
    DisableGadget(#OffsetSpin, 1)
    CheckBoxGadget(#PassableCheckBox, #PassableCheckBox_x, #PassableCheckBox_y, #PassableCheckBox_w, #PassableCheckBox_h, "Passable")
    CheckBoxGadget(#TileTopCheckBox, #TileTopCheckBox_x, #TileTopCheckBox_y, #TileTopCheckBox_w, #TileTopCheckBox_h, "Tile top =")
    SpinGadget(#TileTopSpin, #TileTopSpin_x, #TileTopSpin_y, #TileTopSpin_w, #TileTopSpin_h, 0, #TILE_HEIGHT, #PB_Spin_Numeric)
    SetGadgetState(#TileTopSpin, 0)
    DisableGadget(#TileTopSpin, 1)
    CheckBoxGadget(#MaskCheckBox, #MaskCheckBox_x, #MaskCheckBox_y, #MaskCheckBox_w, #MaskCheckBox_h, "Mask :")
    ComboBoxGadget(#ComboBox2, #ComboBox2_x, #ComboBox2_y, #ComboBox2_w, #ComboBox2_h, #PB_ComboBox_Image)
    If DatabaseQuery(#Database, "SELECT * FROM mask ORDER BY id;")
      While NextDatabaseRow(#Database)
        AddGadgetItem(#ComboBox2, -1, GetDatabaseString(#Database, 1), ImageID(LoadImage(#PB_Any, "masks\"+GetDatabaseString(#Database, 1))))
      Wend
      FinishDatabaseQuery(#Database)
    Else
      MessageRequester("DatabaseUpdate() error", DatabaseError())
      End
    EndIf
    DisableGadget(#ComboBox2, 1)
    Frame3DGadget(#CollisionFrame3D, #CollisionFrame3D_x, #CollisionFrame3D_y, #CollisionFrame3D_w, #CollisionFrame3D_h, "Collision")
    EditorGadget(#CollisionEditor, #CollisionEditor_x, #CollisionEditor_y, #CollisionEditor_w, #CollisionEditor_h)
    Frame3DGadget(#InteractionFrame3D, #InteractionFrame3D_x, #InteractionFrame3D_y, #InteractionFrame3D_w, #InteractionFrame3D_h, "Interaction")
    EditorGadget(#InteractionEditor, #InteractionEditor_x, #InteractionEditor_y, #InteractionEditor_w, #InteractionEditor_h)
    ButtonGadget(#OKButton4, #OKButton4_x, #OKButton4_y, #OKButton4_w, #OKButton4_h, "Ok")
    ButtonGadget(#CancelButton4, #CancelButton4_x, #CancelButton4_y, #CancelButton4_w, #CancelButton4_h, "Cancel")
    
    Protected ok.l = 0, quit.l = 0, id.l, mask.l
    DisableWindow(#Window, 1)
    DisableGadget(#OKButton4, 1)
    Repeat
      Select WaitWindowEvent()
        Case #PB_Event_Gadget
          Select EventGadget()
            Case #ComboBox
              If GetGadgetState(#ComboBox) <> -1
                DisableGadget(#OKButton4, 0)
              Else
                DisableGadget(#OKButton4, 1)
              EndIf
            Case #AnimCheckBox
              If GetGadgetState(#AnimCheckBox) = #PB_Checkbox_Checked
                DisableGadget(#OffsetSpin, 0)
              Else
                DisableGadget(#OffsetSpin, 1)
              EndIf
            Case #TileTopCheckBox
              If GetGadgetState(#TileTopCheckBox) = #PB_Checkbox_Checked
                DisableGadget(#TileTopSpin, 0)
              Else
                DisableGadget(#TileTopSpin, 1)
              EndIf
            Case #MaskCheckBox
              If GetGadgetState(#MaskCheckBox) = #PB_Checkbox_Checked
                DisableGadget(#ComboBox2, 0)
              Else
                DisableGadget(#ComboBox2, 1)
              EndIf
            Case #OKButton4
              ok = 1
              quit = 1
            Case #CancelButton4
              ok = 0
              quit = 1
          EndSelect
        Default
          Delay(10)
      EndSelect
    Until quit
    If ok
      If DatabaseQuery(#Database, "SELECT max(id) FROM brush;")
        NextDatabaseRow(#Database)
        id = GetDatabaseDouble(#Database, 0)
        If MapSize(brushes())>0
          id+1
        EndIf
        If GetGadgetState(#MaskCheckBox) = #PB_Checkbox_Unchecked
          mask = 0
        Else
          mask = GetGadgetState(#ComboBox2)
        EndIf
        If DatabaseUpdate(#Database, "INSERT INTO brush (id, tile, animation, offset, passable, height, masked, mask, collision, interaction) VALUES ('"+Str(id)+"', '"+Str(GetGadgetState(#ComboBox))+"', '"+Str(GetGadgetState(#AnimCheckBox))+"', '"+Str(GetGadgetState(#OffsetSpin))+"', '"+Str(GetGadgetState(#PassableCheckBox))+"', '"+Str(GetGadgetState(#TileTopSpin))+"', '"+Str(GetGadgetState(#MaskCheckBox))+"', '"+Str(mask)+"', '"+GetGadgetText(#CollisionEditor)+"', '"+GetGadgetText(#InteractionEditor)+"');")
          ForEach brushes()
            FreeImage(Val(MapKey(brushes())))
          Next
          brushes(Str(id))\tile = GetGadgetState(#ComboBox)
          brushes(Str(id))\animation = GetGadgetState(#AnimCheckBox)
          brushes(Str(id))\offset = GetGadgetState(#OffsetSpin)
          brushes(Str(id))\passable = GetGadgetState(#PassableCheckBox)
          brushes(Str(id))\height = GetGadgetState(#TileTopSpin)
          brushes(Str(id))\masked = GetGadgetState(#MaskCheckBox)
          brushes(Str(id))\mask = mask
          brushes(Str(id))\collision = GetGadgetText(#CollisionEditor)
          brushes(Str(id))\interaction = GetGadgetText(#InteractionEditor)
          ClearGadgetItems(#BrushesListIcon)
          RefreshBrushes()
        Else
          MessageRequester("DatabaseUpdate() error", DatabaseError())
          End
        EndIf
        FinishDatabaseQuery(#Database)
      EndIf
    EndIf
    CloseWindow(#Window_new_brush)
    DisableWindow(#Window, 0)
    SetActiveWindow(#Window)
  EndIf
EndProcedure

Procedure Edit_brush(id.l)
  If OpenWindow(#Window_new_brush, 0, 0, #Window_new_brush_w, #Window_new_brush_h, "Edit brush", #PB_Window_WindowCentered | #PB_Window_TitleBar, WindowID(#Window))
    TextGadget(#TileText, #TileText_x, #TileText_y, #TileText_w, #TileText_h, "Tile : ")
    ComboBoxGadget(#ComboBox, #ComboBox_x, #ComboBox_y, #ComboBox_w, #ComboBox_h, #PB_ComboBox_Image)
    If DatabaseQuery(#Database, "SELECT * FROM tile ORDER BY id;")
      While NextDatabaseRow(#Database)
        AddGadgetItem(#ComboBox, -1, GetDatabaseString(#Database, 1), ImageID(LoadImage(#PB_Any, "tiles\"+GetDatabaseString(#Database, 1))))
      Wend
      FinishDatabaseQuery(#Database)
    Else
      MessageRequester("DatabaseUpdate() error", DatabaseError())
      End
    EndIf
    SetGadgetState(#ComboBox, brushes(Str(id))\tile)
    CheckBoxGadget(#AnimCheckBox, #AnimCheckBox_x, #AnimCheckBox_y, #AnimCheckBox_w, #AnimCheckBox_h, "Animation")
    SetGadgetState(#AnimCheckBox, brushes(Str(id))\animation)
    TextGadget(#OffsetText, #OffsetText_x, #OffsetText_y, #OffsetText_w, #OffsetText_h, ", offset #")
    SpinGadget(#OffsetSpin, #OffsetSpin_x, #OffsetSpin_y, #OffsetSpin_w, #OffsetSpin_h, 0, 255, #PB_Spin_Numeric)
    SetGadgetState(#OffsetSpin, brushes(Str(id))\offset)
    If GetGadgetState(#AnimCheckBox) = #PB_Checkbox_Unchecked
      DisableGadget(#OffsetSpin, 1)
    EndIf
    CheckBoxGadget(#PassableCheckBox, #PassableCheckBox_x, #PassableCheckBox_y, #PassableCheckBox_w, #PassableCheckBox_h, "Passable")
    SetGadgetState(#PassableCheckBox, brushes(Str(id))\passable)
    CheckBoxGadget(#TileTopCheckBox, #TileTopCheckBox_x, #TileTopCheckBox_y, #TileTopCheckBox_w, #TileTopCheckBox_h, "Tile top =")
    SpinGadget(#TileTopSpin, #TileTopSpin_x, #TileTopSpin_y, #TileTopSpin_w, #TileTopSpin_h, 0, #TILE_HEIGHT, #PB_Spin_Numeric)
    CheckBoxGadget(#MaskCheckBox, #MaskCheckBox_x, #MaskCheckBox_y, #MaskCheckBox_w, #MaskCheckBox_h, "Mask :")
    SetGadgetState(#MaskCheckBox, brushes(Str(id))\masked)
    ComboBoxGadget(#ComboBox2, #ComboBox2_x, #ComboBox2_y, #ComboBox2_w, #ComboBox2_h, #PB_ComboBox_Image)
    If DatabaseQuery(#Database, "SELECT * FROM mask ORDER BY id;")
      While NextDatabaseRow(#Database)
        AddGadgetItem(#ComboBox2, -1, GetDatabaseString(#Database, 1), ImageID(LoadImage(#PB_Any, "masks\"+GetDatabaseString(#Database, 1))))
      Wend
      FinishDatabaseQuery(#Database)
    Else
      MessageRequester("DatabaseUpdate() error", DatabaseError())
      End
    EndIf
    SetGadgetState(#Combobox2, brushes(Str(id))\mask)
    If brushes(Str(id))\masked = 0
      DisableGadget(#Combobox2, 1)
    EndIf
    Frame3DGadget(#CollisionFrame3D, #CollisionFrame3D_x, #CollisionFrame3D_y, #CollisionFrame3D_w, #CollisionFrame3D_h, "Collision")
    EditorGadget(#CollisionEditor, #CollisionEditor_x, #CollisionEditor_y, #CollisionEditor_w, #CollisionEditor_h)
    SetGadgetText(#CollisionEditor, brushes(Str(id))\collision)
    Frame3DGadget(#InteractionFrame3D, #InteractionFrame3D_x, #InteractionFrame3D_y, #InteractionFrame3D_w, #InteractionFrame3D_h, "Interaction")
    EditorGadget(#InteractionEditor, #InteractionEditor_x, #InteractionEditor_y, #InteractionEditor_w, #InteractionEditor_h)
    SetGadgetText(#InteractionEditor, brushes(Str(id))\interaction)
    ButtonGadget(#OKButton4, #OKButton4_x, #OKButton4_y, #OKButton4_w, #OKButton4_h, "Ok")
    ButtonGadget(#CancelButton4, #CancelButton4_x, #CancelButton4_y, #CancelButton4_w, #CancelButton4_h, "Cancel")
    
    Protected ok.l = 0, quit.l = 0, mask.l
    DisableWindow(#Window, 1)
    Repeat
      Select WaitWindowEvent()
        Case #PB_Event_Gadget
          Select EventGadget()
            Case #ComboBox
              If GetGadgetState(#ComboBox) <> -1
                DisableGadget(#OKButton4, 0)
              Else
                DisableGadget(#OKButton4, 1)
              EndIf
            Case #AnimCheckBox
              If GetGadgetState(#AnimCheckBox) = #PB_Checkbox_Checked
                DisableGadget(#OffsetSpin, 0)
              Else
                DisableGadget(#OffsetSpin, 1)
              EndIf
            Case #TileTopCheckBox
              If GetGadgetState(#TileTopCheckBox) = #PB_Checkbox_Checked
                DisableGadget(#TileTopSpin, 0)
              Else
                DisableGadget(#TileTopSpin, 1)
              EndIf
            Case #MaskCheckBox
              If GetGadgetState(#MaskCheckBox) = #PB_Checkbox_Checked
                DisableGadget(#ComboBox2, 0)
              Else
                DisableGadget(#ComboBox2, 1)
              EndIf
            Case #OKButton4
              ok = 1
              quit = 1
            Case #CancelButton4
              ok = 0
              quit = 1
          EndSelect
        Default
          Delay(10)
      EndSelect
    Until quit
    If ok
      ForEach brushes()
        FreeImage(Val(MapKey(brushes())))
      Next
      If GetGadgetState(#MaskCheckBox) = #PB_Checkbox_Unchecked
        mask = 0
      Else
        mask = GetGadgetState(#ComboBox2)
      EndIf
      brushes(Str(id))\tile = GetGadgetState(#ComboBox)
      brushes(Str(id))\animation = GetGadgetState(#AnimCheckBox)
      brushes(Str(id))\offset = GetGadgetState(#OffsetSpin)
      brushes(Str(id))\passable = GetGadgetState(#PassableCheckBox)
      brushes(Str(id))\height = GetGadgetState(#TileTopSpin)
      brushes(Str(id))\masked = GetGadgetState(#MaskCheckBox)
      brushes(Str(id))\mask = mask
      brushes(Str(id))\collision = GetGadgetText(#CollisionEditor)
      brushes(Str(id))\interaction = GetGadgetText(#InteractionEditor)
      If DatabaseUpdate(#Database, "UPDATE brush SET tile='"+Str(brushes(Str(id))\tile)+"', animation='"+Str(brushes(Str(id))\animation)+"', offset='"+Str(brushes(Str(id))\offset)+"', passable='"+Str(brushes(Str(id))\passable)+"', height='"+Str(brushes(Str(id))\height)+"', masked='"+Str(brushes(Str(id))\masked)+"', mask='"+Str(mask)+"', collision='"+brushes(Str(id))\collision+"', interaction='"+brushes(Str(id))\interaction+"' WHERE id='"+Str(id)+"';")
        ClearGadgetItems(#BrushesListIcon)
        RefreshBrushes()
      Else
        MessageRequester("DatabaseUpdate() error", DatabaseError())
        End
      EndIf
    EndIf
    CloseWindow(#Window_new_brush)
    DisableWindow(#Window, 0)
    SetActiveWindow(#Window)
  EndIf
EndProcedure

Procedure SaveBrushes()
  If DatabaseUpdate(#Database, "DELETE FROM brush;")
    FinishDatabaseQuery(#Database)
    ForEach brushes()
      If DatabaseUpdate(#Database, "INSERT INTO brush (id, tile, animation, offset, passable, height, masked, mask, collision, interaction) VALUES ('"+MapKey(brushes())+"', '"+Str(brushes()\tile)+"', '"+Str(brushes()\animation)+"', '"+Str(brushes()\offset)+"', '"+Str(brushes()\passable)+"', '"+Str(brushes()\height)+"', '"+Str(brushes()\masked)+"', '"+Str(brushes()\mask)+"', '"+brushes()\collision+"', '"+brushes()\interaction+"');")
        FinishDatabaseQuery(#Database)
      Else
        MessageRequester("DatabaseUpdate() error", DatabaseError())
        End
      EndIf
    Next
  Else
    MessageRequester("DatabaseUpdate() error", DatabaseError())
    End
  EndIf
EndProcedure
; IDE Options = PureBasic 4.60 (Windows - x86)
; CursorPosition = 236
; FirstLine = 221
; Folding = -
; EnableXP
; UseMainFile = main.pb
; CurrentDirectory = ..\